# Official Repository of the End of a New Beginning Mod ![github-size]  ![github-stars]

### Media      [![Patreon][patreon-badge]][patreon-link]   [![Steam][steam-badge]][steam-link]   [![Discord][discord-badge]][discord-link]

[github-size]: https://img.shields.io/github/languages/code-size/EoaNB-Team/EoaNB
[github-stars]: https://img.shields.io/github/stars/EoaNB-Team/EoaNB?style=social

[patreon-badge]: https://img.shields.io/static/v1?label=Patreon&message=Donate&color=orange&logo=patreon
[patreon-link]: https://www.patreon.com/mod_eoanb

[steam-badge]: https://img.shields.io/static/v1?label=Steam&message=Download&color=lightgrey&logo=steam	
[steam-link]: https://steamcommunity.com/sharedfiles/filedetails/?id=2856963714

[discord-badge]: https://img.shields.io/static/v1?label=Discord&message=Chat&color=blue&logo=discord
[discord-link]: https://discord.gg/VgufEME

<hr>

## Navigation
* [What is this?](#what-is-this?)
* [Installation/Download](#installing-the-mod)
* [Usage](#usage)
* [Troubleshooting](#troubleshooting)
* [Join the Discussion](#meet-the-team;-join-the-discussion)

<hr>

## What is this?

This site is the official respository (cloud) for sharing and cooperating in the development of the Hearts of Iron IV mod, **End of a New Beginning**. Here, you can learn how to join our community, install our mod, and join/support the development team.

<img src="https://github.com/team-eoanb/EoaNB-Wallpapers/blob/main/banner_vertersus.png?raw=true" width="720px;" align="middle" alt="End of a New Beginning — Pax Orientalis Banner"/>

<hr>

## Installing the Mod (currently being reworked)

Get easy access to our open-source development, with just a few quick steps!
Here's a useful installation video by one of our former lead developers: 

<a href="https://www.youtube.com/watch?v=00UqzQT8W68">Video Link: https://www.youtube.com/watch?v=00UqzQT8W68</a>

### Links from the Video 
* <a href="https://desktop.github.com/">Github Desktop App: https://desktop.github.com/</a>
* <a href="https://github.com/EoaNB-Team/EoaNB">Github Repo URL: https://github.com/EoaNB-Team/EoaNB</a>

<hr>

## Usage

**End of a New Beginning** is a `free to play, open source mod`.

If you would like to work on the mod but do not wish to apply for the team, you are free to fork the repository and modify it, and redistribute it for private use. Content of EoaNB is licensed under the `GNU General Public License 3.0`, which means you have to alert users you are redistributing a modified, unofficial version of EoaNB.

We do not tolerate using content developed for EoaNB for other purposes. Any other source doing such things without our explicit permision and/or are claiming ownership/profiting from our work may be liable to legal disputes.

<hr>

## Troubleshooting

### Crashes
`Recalculating Naval Distances Crash`: The current build of our mod crashes during the game-booting process between the launcher window and the main menu for some users with incompatible graphics cards. A good fix for most users has been to enter the Steam Library and enter the option `-opengl` into Hearts of Iron 4's launch settings. <a href="https://github.com/team-eoanb/EoaNB/wiki/Common-Troubleshooting-Actions"> Instructions Here</a>

`Railgun Crash`: There is a railgun tech in our mod that crashes the user when they hover over the tech icon. We are still unsure what is causing this crash and are looking for a fix.

### Other notable issues
`Save Game Load Times`: It is a notable issue of how long save games take to load. Our average developer notices it takes them 5-10 minutes to load a save; longer as the game progresses past 1880. This issue is to be addressed with Ars Bellica.

<hr>

## Meet the Team; Join the Discussion

Have more questions, comments or feedback? You can contact us by joining our discord:

<a href="https://discord.gg/VgufEME">- Discord Link: https://discord.gg/VgufEME</a>

<hr>

## Join the Team

If you wish to contribute to the development of the mod, support us on Patreon or join the team. The links to support/apply can be found in our `#faq` channel on Discord. Donators will be given the special Auxillaires role on Discord which gives backdoor access to most of our development process/work and given special personalized easter eggs in our mod. Applicant Developers will be given the `Curia` Team Member Role and the `Disciplio` Trial Role. After passing the Trial Period, members will be fully accepted into the team and be given GitHub write access if applicable.

### Rules for Developers
- Current General Development for EoaNB shall be pushed onto the `(0.5)-Sanguis in Harenis` branch.
- All code should be error-checked before pushed onto the Github
- Merging should be done carefully and procedurely. Do not override other developers' work without acknowledgment of the team.
- If procedural pushing (including incomplete content) is crucial to development, request a new branch.
- Merging any branch into the master branch (the distributed branch) will require a pull request which can only be initialised by a *Centurion*, and requires the approval of at least another Centurion. Errors are to be checked and minimalised by the Centurion who does the request.
- Additional rules in the **Developer Bible**

### Meet the Lead-Developers
*aka Centurions*
<table>
<tr>
<td align="center">
  <a href = "https://github.com/Sir-DEM0"><strong>DEM0</strong></a>
  <img src="https://avatars.githubusercontent.com/u/84448163" width="80px;" alt="DEM0"/>
</td>
<td align="center">
  <a href = "https://github.com/Syrexx-x"><strong>Syrexx</strong></a>
  <img src="https://avatars.githubusercontent.com/u/138278445?v=4" width="80px;" alt="Syrexx"/>
</td>
<td align="center">
  <a href = "https://github.com/Polskastronkkurwa"><strong>Kuba</strong></a>
  <img src="https://avatars.githubusercontent.com/u/34871134?v=4" width="80px;" alt="Kuba"/>
</td>
  <td align="center">
  <a href = "https://github.com/aquamarinespitfire"><strong>Aquamarine</strong></a>
  <img src="https://avatars.githubusercontent.com/u/135063414?v=4" width="80px;" alt="Aquamarine"/>
</td>
<td align="center">
  <a href = "https://github.com/gsbr20"><strong>gsbr</strong></a>
  <img src="https://avatars.githubusercontent.com/u/93613957?v=4" width="80px;" alt="gsbr"/>
</td>
</tr>
</table>
